// BaseParaSet.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"
#include "BaseParaSet.h"
#include "CtrlCard.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CCtrlCard g_CtrlCard;
/////////////////////////////////////////////////////////////////////////////
// CBaseParaSet dialog


CBaseParaSet::CBaseParaSet(CWnd* pParent /*=NULL*/)
	: CDialog(CBaseParaSet::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBaseParaSet)
	m_nEffectLogic_w = -1;
	m_nEffectLogic_x = -1;
	m_nEffectLogic_y = -1;
	m_nEffectLogic_z = -1;
	m_nNLimitMode_w = -1;
	m_nNLimitMode_x = -1;
	m_nNLimitMode_y = -1;
	m_nNLimitMode_z = -1;
	m_nPLimitMode_w = -1;
	m_nPLimitMode_x = -1;
	m_nPLimitMode_y = -1;
	m_nPLimitMode_z = -1;
	m_nPulseMode_w = -1;
	m_nPulseMode_x = -1;
	m_nPulseMode_y = -1;
	m_nPulseMode_z = -1;
	m_nStop0Mode_w = -1;
	m_nStop0Mode_x = -1;
	m_nStop0Mode_y = -1;
	m_nStop0Mode_z = -1;
	m_nStop1Mode_w = -1;
	m_nStop1Mode_x = -1;
	m_nStop1Mode_y = -1;
	m_nStop1Mode_z = -1;
	//}}AFX_DATA_INIT
}


void CBaseParaSet::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBaseParaSet)
	DDX_Radio(pDX, IDC_EFFECTLOGIC_W, m_nEffectLogic_w);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_X, m_nEffectLogic_x);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_Y, m_nEffectLogic_y);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_Z, m_nEffectLogic_z);
	DDX_Radio(pDX, IDC_NLIMITMODE_W, m_nNLimitMode_w);
	DDX_Radio(pDX, IDC_NLIMITMODE_X, m_nNLimitMode_x);
	DDX_Radio(pDX, IDC_NLIMITMODE_Y, m_nNLimitMode_y);
	DDX_Radio(pDX, IDC_NLIMITMODE_Z, m_nNLimitMode_z);
	DDX_Radio(pDX, IDC_PLIMITMODE_W, m_nPLimitMode_w);
	DDX_Radio(pDX, IDC_PLIMITMODE_X, m_nPLimitMode_x);
	DDX_Radio(pDX, IDC_PLIMITMODE_Y, m_nPLimitMode_y);
	DDX_Radio(pDX, IDC_PLIMITMODE_Z, m_nPLimitMode_z);
	DDX_Radio(pDX, IDC_PULSEMODE_W, m_nPulseMode_w);
	DDX_Radio(pDX, IDC_PULSEMODE_X, m_nPulseMode_x);
	DDX_Radio(pDX, IDC_PULSEMODE_Y, m_nPulseMode_y);
	DDX_Radio(pDX, IDC_PULSEMODE_Z, m_nPulseMode_z);
	DDX_Radio(pDX, IDC_STOP0MODE_W, m_nStop0Mode_w);
	DDX_Radio(pDX, IDC_STOP0MODE_X, m_nStop0Mode_x);
	DDX_Radio(pDX, IDC_STOP0MODE_Y, m_nStop0Mode_y);
	DDX_Radio(pDX, IDC_STOP0MODE_Z, m_nStop0Mode_z);
	DDX_Radio(pDX, IDC_STOP1MODE_W, m_nStop1Mode_w);
	DDX_Radio(pDX, IDC_STOP1MODE_X, m_nStop1Mode_x);
	DDX_Radio(pDX, IDC_STOP1MODE_Y, m_nStop1Mode_y);
	DDX_Radio(pDX, IDC_STOP1MODE_Z, m_nStop1Mode_z);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBaseParaSet, CDialog)
	//{{AFX_MSG_MAP(CBaseParaSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBaseParaSet message handlers

BOOL CBaseParaSet::OnInitDialog() 
{
	CDialog::OnInitDialog();
//************ Basic parameter settings ********************// 
	//********* * Output pulse mode *************// 
	// 0 - Pulse + Pulse 1 - Pulse + direction / /
	// default mode for the pulse + direction / /
//***********************************//
    m_nPulseMode_x  = 1;
	m_nPulseMode_y  = 1;
	m_nPulseMode_z  = 1;
	m_nPulseMode_w  = 1;
//********** Limit mode is set ***********//
// 0 - are limit the effective 1 - Limit is invalid //
// default limit mode are valid / /

//***********************************//
	m_nPLimitMode_x = 0;
	m_nPLimitMode_y = 0;
	m_nPLimitMode_z = 0;
	m_nPLimitMode_w = 0;
//********** Negative limit mode is set to ***********// 
// 0 - Negative limit effective 1 - negative limit is invalid //
// default model for the negative limit valid / /

//***********************************//
	m_nNLimitMode_x = 0;
	m_nNLimitMode_y = 0;
	m_nNLimitMode_z = 0;
	m_nNLimitMode_w = 0;
//*********** STOP0 mode setting ***********// 
// 0 - invalid 1 - effective //
// default mode is invalid / /
//***********************************//
	m_nStop0Mode_x  = 0;
	m_nStop0Mode_y  = 0;
	m_nStop0Mode_z  = 0;
	m_nStop0Mode_w  = 0;
//*********** STOP1 mode setting ***********// 
// 0 - invalid 1 - effective // 
// default mode is invalid / /
//***********************************//
	m_nStop1Mode_x  = 0;
	m_nStop1Mode_y  = 0;
	m_nStop1Mode_z  = 0;
	m_nStop1Mode_w  = 0;
//*********** Level mode setting ************// 
// This is the limit, STOP0, STOP1 mode level set //
// 0 - active low 1 - high effective // 
// default mode for the low efficiency / /

//***********************************//
	m_nEffectLogic_x = 0;
	m_nEffectLogic_y = 0;
	m_nEffectLogic_z = 0;
	m_nEffectLogic_w = 0;

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CBaseParaSet::OnOK() 
{
	UpdateData();

	int  pulsemode[]={m_nPulseMode_x, m_nPulseMode_y, m_nPulseMode_z, m_nPulseMode_w};    //ʽ      

	int  plimitmode[]={m_nPLimitMode_x, m_nPLimitMode_y, m_nPLimitMode_z, m_nPLimitMode_w};   //λģʽ 

	int  nlimitmode[]={m_nNLimitMode_x, m_nNLimitMode_y, m_nNLimitMode_z, m_nNLimitMode_w};   //λģʽ
	
	int  stop0mode[]={m_nStop0Mode_x, m_nStop0Mode_y, m_nStop0Mode_z,m_nStop0Mode_w};         //stop0ģʽ

	int  stop1mode[]={m_nStop1Mode_x, m_nStop1Mode_y, m_nStop1Mode_z,m_nStop1Mode_w};         //stop1ģʽ

	int  effectlogic[]={m_nEffectLogic_x, m_nEffectLogic_y, m_nEffectLogic_z, m_nEffectLogic_w};  //ƽ

	for(int i=1; i<MAXAXIS+1; i++)
	{
		//Pulse output mode setting
		g_CtrlCard.Setup_PulseMode(i, pulsemode[i-1]);             

		//Limit mode is set
		g_CtrlCard.Setup_LimitMode(i, plimitmode[i-1], nlimitmode[i-1], effectlogic[i-1]);

		//stop0 Signal mode settings
		g_CtrlCard.Setup_Stop0Mode(i, stop0mode[i-1], effectlogic[i-1]);

		//stop1 Signal mode settings
		g_CtrlCard.Setup_Stop1Mode(i, stop1mode[i-1], effectlogic[i-1]);
	}

	CDialog::OnOK();
}
